/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.p.pa.event;

import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.domain.DomainIdentifier;
import com.ibm.hwmca.fw.pa.system.PASystem;
import com.ibm.hwmca.fw.util.ByteArray;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.XMLEncodeableArrayList;
import com.ibm.hwmca.p.pa.PelDataConstants;
import com.ibm.hwmca.p.pa.domain.LocalSurveillanceAnalysisDomain;
import com.ibm.hwmca.p.pa.domain.RioTopologyReader;
import com.ibm.hwmca.p.pa.fru.PIFru;
import com.ibm.hwmca.xfw.pa.event.DistributedDataEvent;
import com.ibm.hwmca.xfw.pa.system.RemoteSystem;
import com.ibm.hwmca.xfw.pa.system.RemoteSystemManager;
import com.ibm.hwmca.xfw.panel.CaptionValuePairing;
import com.ibm.hwmca.xfw.panel.LocalizablePanelValue;
import com.ibm.hwmca.xfw.panel.LocalizableTimePanelValue;
import com.ibm.hwmca.xfw.panel.NonLocalizablePanelValue;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class PelDataEvent
extends DistributedDataEvent {
    private static final String TRACE_MASKT = "PPAPDEVT";
    private static final String TRACE_MASKF = "PPAPDEVF";
    private static final String TRACE_MASKD = "PPAPDEVD";
    protected int fipsLogId = 0;
    protected String creatorID = "";
    protected LocalizableText eventType = null;
    protected XMLEncodeableArrayList drawerMTMSList = new XMLEncodeableArrayList();
    protected String bpcEED = "";
    private static final int MINIMUM_SECTION_LENGTH = 8;
    private byte[] privateHeader = null;
    private byte[] userHeader = null;
    private byte[] primarySRC = null;
    private byte[] failingMTMS = null;
    private XMLEncodeableArrayList secondarySRC = new XMLEncodeableArrayList();
    private byte[] dumpLocator = null;
    private XMLEncodeableArrayList firmwareError = new XMLEncodeableArrayList();
    private byte[] impactedPartition = null;
    private byte[] logicalResourceID = null;
    private byte[] hmcID = null;
    private byte[] epow = null;
    private byte[] ioEvent = null;
    private byte[] mfgInfo = null;
    private XMLEncodeableArrayList userData = new XMLEncodeableArrayList();
    private String _rioLoopId = null;
    private boolean hidden = false;
    private boolean reportExternally = false;

    public PelDataEvent(Object source) {
        super(source);
        Trace.trace(TRACE_MASKD, "<-> ctor");
        this.setPriority(40.0f);
    }

    public PelDataEvent(Object source, String evtId) {
        super(source, evtId);
        Trace.trace(TRACE_MASKD, "<-> ctor");
        this.setPriority(40.0f);
    }

    protected void parseData() throws HException {
        this.extractSections(this.logData);
        if (this.privateHeader == null || this.userHeader == null) {
            Trace.trace(TRACE_MASKT, "PEL data formatting error - no PH or US section");
            throw new HException("PEL data formatting error - no PH or US section");
        }
        this.setEventSeverity(ByteArray.extractU8(this.userHeader, 10));
        this.eventType = this.isInfo() ? new BaseMessageText("XPA7620") : new BaseMessageText("XPA7621");
        if (this.isError() && (this.primarySRC == null || this.failingMTMS == null)) {
            Trace.trace(TRACE_MASKT, "PEL data formatting error - no PS or MT section");
            throw new HException("PEL data formatting error - no PS or MT section");
        }
        int errActionFlags = ByteArray.extractU16(this.userHeader, 18, false);
        if ((errActionFlags & 0x800) == 2048) {
            this.setNotificationType(new LocalizableText("Call Home Required"));
        } else if ((errActionFlags & 0x8000) == 32768) {
            this.setNotificationType(new LocalizableText("Service Action (customer notification) Required"));
        }
        if ((errActionFlags & 0x4000) == 16384) {
            this.hidden = true;
        }
        if ((errActionFlags & 0x2000) == 8192) {
            this.reportExternally = true;
        }
        this.setPlatformLogID((int)ByteArray.extractU32(this.privateHeader, 40, false));
        this.fipsLogId = (int)ByteArray.extractU32(this.privateHeader, 44, false);
        this.creatorID = new String(ByteArray.extractBytes(this.privateHeader, 24, 1, false)).trim();
        if (this.failingMTMS != null) {
            String failingEnclMTMS = this.parsePelMTMS(this.failingMTMS, 8);
            Trace.trace(TRACE_MASKD, "failingEnclMTMS=" + failingEnclMTMS);
            RemoteSystem remSystem = new RemoteSystem(PASystem.extractMachineType(failingEnclMTMS), PASystem.extractMachineModel(failingEnclMTMS), PASystem.extractMachineSerial(failingEnclMTMS));
            RemoteSystemManager rsm = RemoteSystemManager.getRemoteSystemManager();
            if (rsm != null) {
                RemoteSystem knownSys = rsm.getKnownSystem(remSystem);
                if (knownSys != null) {
                    Trace.trace(TRACE_MASKD, "Associating system with RemoteSystemManager reference [" + knownSys.getUniqueKey() + "]");
                    remSystem = knownSys;
                } else {
                    Trace.trace(TRACE_MASKT, "Not a known RemoteSystemManager-controlled system.  Should it be?");
                }
            }
            this.setFailingEnclosureSystem(remSystem);
        } else {
            this.setFailingEnclosureSystem(this.getSystem());
        }
        if (this.primarySRC != null) {
            this.parseSRC();
        }
        this.setSubsystemID(ByteArray.extractU8(this.userHeader, 8));
        this.setSvcEventText(Integer.toString(this.getSubsystemID()) + Integer.toString(this.getEventSeverity()));
        int year = Integer.valueOf(Integer.toHexString(ByteArray.extractU16(this.privateHeader, 8, false)), 10);
        int month = Integer.valueOf(Integer.toHexString(ByteArray.extractU8(this.privateHeader, 10)), 10);
        int day = Integer.valueOf(Integer.toHexString(ByteArray.extractU8(this.privateHeader, 11)), 10);
        int hour = Integer.valueOf(Integer.toHexString(ByteArray.extractU8(this.privateHeader, 12)), 10);
        int min = Integer.valueOf(Integer.toHexString(ByteArray.extractU8(this.privateHeader, 13)), 10);
        int sec = Integer.valueOf(Integer.toHexString(ByteArray.extractU8(this.privateHeader, 14)), 10);
        int hun = Integer.valueOf(Integer.toHexString(ByteArray.extractU8(this.privateHeader, 15)), 10);
        Calendar cal = Calendar.getInstance();
        cal.set(year, month - 1, day, hour, min, sec);
        this.setFirstReportedTime(cal.getTimeInMillis() + (long)(hun * 10));
        this.drawerMTMSList = new XMLEncodeableArrayList();
        this.bpcEED = "";
        this.addAssociatedSystem(this.getSystem());
        this.setDomainId(this.determineDomain());
        this.setDataId(new Integer(this.getPlatformLogID()).toString() + "//" + new Integer(this.fipsLogId).toString());
        Trace.trace(TRACE_MASKD, "<-> parseData");
    }

    private void extractSections(byte[] logData) throws HException {
        int phCount = 0;
        int uhCount = 0;
        int psCount = 0;
        int fmCount = 0;
        int ssCount = 0;
        int dlCount = 0;
        int feCount = 0;
        int ipCount = 0;
        int lrCount = 0;
        int hiCount = 0;
        int miCount = 0;
        int udCount = 0;
        int epCount = 0;
        int ieCount = 0;
        int i = 0;
        while (i < logData.length) {
            if (logData.length - i < 8) {
                Trace.trace(TRACE_MASKT, "PEL data formatting error - insufficient data for another section");
                throw new HException("PEL data formatting error - insufficient data for another section");
            }
            byte[] sectionID = new byte[]{logData[i], logData[i + 1]};
            int sectionLength = ByteArray.extractU16(logData, i + 2, false);
            if (sectionLength == 0) {
                Trace.trace(TRACE_MASKT, "PEL data formatting error - section length of 0");
                throw new HException("PEL data formatting error - section length of 0");
            }
            if (logData.length - i < sectionLength) {
                Trace.trace(TRACE_MASKT, "PEL data formatting error - insufficient data for specified section length");
                throw new HException("PEL data formatting error - insufficient data for specified section length");
            }
            byte[] section = ByteArray.extractBytes(logData, i, sectionLength, false);
            if (sectionID[0] == PelDataConstants.SECTION_ID_PRIVATE_HEADER[0] && sectionID[1] == PelDataConstants.SECTION_ID_PRIVATE_HEADER[1]) {
                this.privateHeader = section;
                ++phCount;
            } else if (sectionID[0] == PelDataConstants.SECTION_ID_USER_HEADER[0] && sectionID[1] == PelDataConstants.SECTION_ID_USER_HEADER[1]) {
                this.userHeader = section;
                ++uhCount;
            } else if (sectionID[0] == PelDataConstants.SECTION_ID_PRIMARY_SRC[0] && sectionID[1] == PelDataConstants.SECTION_ID_PRIMARY_SRC[1]) {
                this.primarySRC = section;
                ++psCount;
            } else if (sectionID[0] == PelDataConstants.SECTION_ID_FAILING_ENCLOSURE_MTMS[0] && sectionID[1] == PelDataConstants.SECTION_ID_FAILING_ENCLOSURE_MTMS[1]) {
                this.failingMTMS = section;
                ++fmCount;
            } else if (sectionID[0] == PelDataConstants.SECTION_ID_SECONDARY_SRC[0] && sectionID[1] == PelDataConstants.SECTION_ID_SECONDARY_SRC[1]) {
                this.secondarySRC.add(section);
                ++ssCount;
            } else if (sectionID[0] == PelDataConstants.SECTION_ID_DUMP_LOCATOR[0] && sectionID[1] == PelDataConstants.SECTION_ID_DUMP_LOCATOR[1]) {
                this.dumpLocator = section;
                ++dlCount;
            } else if (sectionID[0] == PelDataConstants.SECTION_ID_FIRMWARE_ERROR[0] && sectionID[1] == PelDataConstants.SECTION_ID_FIRMWARE_ERROR[1]) {
                this.firmwareError.add(section);
                ++feCount;
            } else if (sectionID[0] == PelDataConstants.SECTION_ID_IMPACTED_PARTITION[0] && sectionID[1] == PelDataConstants.SECTION_ID_IMPACTED_PARTITION[1]) {
                this.impactedPartition = section;
                ++ipCount;
            } else if (sectionID[0] == PelDataConstants.SECTION_ID_LOGICAL_RESOURCE_ID[0] && sectionID[1] == PelDataConstants.SECTION_ID_LOGICAL_RESOURCE_ID[1]) {
                this.logicalResourceID = section;
                ++lrCount;
            } else if (sectionID[0] == PelDataConstants.SECTION_ID_HMC_ID[0] && sectionID[1] == PelDataConstants.SECTION_ID_HMC_ID[1]) {
                this.hmcID = section;
                ++hiCount;
            } else if (sectionID[0] == PelDataConstants.SECTION_ID_EPOW[0] && sectionID[1] == PelDataConstants.SECTION_ID_EPOW[1]) {
                this.epow = section;
                ++epCount;
            } else if (sectionID[0] == PelDataConstants.SECTION_ID_IO_EVENT[0] && sectionID[1] == PelDataConstants.SECTION_ID_IO_EVENT[1]) {
                this.ioEvent = section;
                ++ieCount;
            } else if (sectionID[0] == PelDataConstants.SECTION_ID_MFG_INFO[0] && sectionID[1] == PelDataConstants.SECTION_ID_MFG_INFO[1]) {
                this.mfgInfo = section;
                ++miCount;
            } else if (sectionID[0] == PelDataConstants.SECTION_ID_USER_DATA[0] && sectionID[1] == PelDataConstants.SECTION_ID_USER_DATA[1]) {
                this.userData.add(section);
                ++udCount;
            }
            i += sectionLength;
        }
        Trace.trace(TRACE_MASKD, "header counts = ");
        Trace.trace(TRACE_MASKD, phCount + " " + uhCount + " " + psCount + " " + fmCount + " " + ssCount + " " + dlCount + " " + feCount + " " + ipCount + " " + lrCount + " " + hiCount + " " + miCount + " " + udCount + " " + epCount + " " + ieCount);
    }

    private void parseSRC() {
        this.setRefcode(new String(ByteArray.extractBytes(this.primarySRC, 48, 8, false)).trim());
        this.setRioLoopId(String.valueOf(ByteArray.extractU16(this.primarySRC, 36, false)).trim());
        int srcLen = ByteArray.extractU16(this.primarySRC, 14, false);
        int mainLen = 80;
        if (srcLen <= mainLen) {
            this.fruList = new XMLEncodeableArrayList();
        } else {
            this.extractFrus(mainLen, srcLen);
        }
    }

    private void extractFrus(int fruOffset, int srcLen) {
        short subsectionID = ByteArray.extractU8(this.primarySRC, fruOffset);
        if (subsectionID != 192) {
            this.fruList = new XMLEncodeableArrayList();
            return;
        }
        int calloutOffset = fruOffset + 4;
        while (calloutOffset < srcLen) {
            PIFru fru = new PIFru();
            short calloutLen = ByteArray.extractU8(this.primarySRC, calloutOffset);
            fru.setReplacementGroup(new String(this.primarySRC, calloutOffset + 2, 1).trim());
            int lcLen = ByteArray.extractU8(this.primarySRC, calloutOffset + 3);
            while (lcLen > 0 && this.primarySRC[calloutOffset + 3 + lcLen] == 0) {
                --lcLen;
            }
            if (lcLen > 0) {
                fru.addLocation(ByteArray.extractString(this.primarySRC, calloutOffset + 4, lcLen).trim());
            }
            int subOffset = calloutOffset + 3 + 1 + ByteArray.extractU8(this.primarySRC, calloutOffset + 3);
            while (subOffset < calloutLen + calloutOffset) {
                short subLen = ByteArray.extractU8(this.primarySRC, subOffset + 2);
                if (this.primarySRC[subOffset] == PelDataConstants.FRU_SUB_IDENTITY[0] && this.primarySRC[subOffset + 1] == PelDataConstants.FRU_SUB_IDENTITY[1]) {
                    short idFlags = ByteArray.extractU8(this.primarySRC, subOffset + 3);
                    fru.setFruClass(idFlags >> 4);
                    if ((idFlags & 8) == 8) {
                        fru.setPartNumber(ByteArray.extractString(this.primarySRC, subOffset + 4, 7).trim());
                        boolean hasCCIN = false;
                        if ((idFlags & 4) == 4) {
                            fru.setCCIN(new String(this.primarySRC, subOffset + 12, 4));
                            hasCCIN = true;
                        }
                        if ((idFlags & 1) == 1) {
                            int snOffset = subOffset + 12;
                            if (hasCCIN) {
                                snOffset += 4;
                            }
                            fru.setSerialNumber(new String(this.primarySRC, snOffset, 12).trim());
                        }
                    } else {
                        fru.setPartNumber(ByteArray.extractString(this.primarySRC, subOffset + 4, 7).trim());
                    }
                } else if (this.primarySRC[subOffset] == PelDataConstants.FRU_SUB_PCE[0] && this.primarySRC[subOffset + 1] == PelDataConstants.FRU_SUB_PCE[1]) {
                    String pcsMTMS = this.parsePelMTMS(this.primarySRC, subOffset + 4);
                    fru.setPowerControllingSystem(new PASystem(PASystem.extractMachineType(pcsMTMS), PASystem.extractMachineModel(pcsMTMS), PASystem.extractMachineSerial(pcsMTMS)));
                } else if (this.primarySRC[subOffset] != PelDataConstants.FRU_SUB_MANUFACTURING[0] || this.primarySRC[subOffset + 1] == PelDataConstants.FRU_SUB_MANUFACTURING[1]) {
                    // empty if block
                }
                subOffset += subLen;
            }
            fru.setEnclosureSystem(this.getFailingEnclosureSystem());
            fru.setLogicControllingSystem(this.getSystem());
            this.addFru(fru);
            calloutOffset += calloutLen;
        }
    }

    private String parsePelMTMS(byte[] srcData, int mtmsOffset) {
        String unformatted = ByteArray.extractString(srcData, mtmsOffset, 20).trim();
        return unformatted.substring(0, 4) + "-" + unformatted.substring(5, 8) + "/" + this.cleanString(unformatted.substring(8));
    }

    protected DomainIdentifier determineDomain() {
        if (this.isRioError()) {
            String rioMTMS = this.getFailingEnclosureSystem().getMTMS();
            String loopId = this.getRioLoopId();
            Trace.trace(TRACE_MASKF, "setting rio loop to be [" + rioMTMS + loopId + "]");
            String domainId = RioTopologyReader.getRioDomainForLoop(rioMTMS, loopId);
            if (domainId == null) {
                domainId = "RIO DEFAULT";
            }
            Trace.trace(TRACE_MASKF, "the domain id is " + domainId);
            return new DomainIdentifier(domainId);
        }
        if (this.isSurveillanceError()) {
            return LocalSurveillanceAnalysisDomain.LSAD_DOMAINID;
        }
        return new DomainIdentifier(this.getFailingEnclosureSystem().getMTMS());
    }

    public String cleanString(String inStr) {
        String returnStr = new String();
        if (inStr == null) {
            return inStr;
        }
        int i = 0;
        while (i < inStr.length()) {
            if (Character.isLetterOrDigit(inStr.charAt(i))) {
                returnStr = returnStr + inStr.charAt(i);
            }
            ++i;
        }
        return returnStr;
    }

    public boolean isError() {
        return this.getEventSeverity() != 0;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isExternal() {
        return this.reportExternally;
    }

    public boolean isInfo() {
        return this.getEventSeverity() == 0;
    }

    public boolean isRioError() {
        int ssid = this.getSubsystemID();
        return ssid == 54 || ssid == 55;
    }

    public boolean isSurveillanceError() {
        int ssid = this.getSubsystemID();
        return ssid == 122 || ssid == 123 || ssid == 124 || ssid == 125 || ssid == 126 || ssid == 127;
    }

    public boolean containsDump() {
        return this.dumpLocator != null;
    }

    public int getFipsLogID() {
        return this.fipsLogId;
    }

    public String getCreatorID() {
        return this.creatorID;
    }

    public LocalizableText getEventType() {
        return this.eventType;
    }

    public List getDrawerMTMSList() {
        return this.drawerMTMSList;
    }

    public String getBPCEED() {
        return this.bpcEED;
    }

    public String toString() {
        String pdeString = new String();
        pdeString = this.getReportingSystem() != null ? pdeString.concat("reporting system MTMS=" + this.getReportingSystem().getMTMS()) : pdeString.concat("reporting system MTMS=not set");
        pdeString = pdeString.concat("\nnotificationType=" + this.getNotificationType());
        pdeString = pdeString.concat("\nplid=" + Integer.toHexString(this.getPlatformLogID()));
        pdeString = pdeString.concat("\nfipsLogId=" + Integer.toHexString(this.getFipsLogID()));
        pdeString = pdeString.concat("\ncreatorID=" + this.getCreatorID());
        pdeString = pdeString.concat("\nrefcode=" + this.getRefcode());
        pdeString = pdeString.concat("\npriority=" + this.getPriority());
        pdeString = pdeString.concat("\nsubsystemID=" + Integer.toHexString(this.getSubsystemID()));
        pdeString = pdeString.concat("\neventType=" + this.getEventType());
        pdeString = pdeString.concat("\neventSeverity=" + Integer.toHexString(this.getEventSeverity()));
        pdeString = this.getFailingEnclosureSystem() != null ? pdeString.concat("\nfailing enclosure system=" + this.getFailingEnclosureSystem().getMTMS()) : pdeString.concat("\nfailing enclosure system=not set");
        pdeString = pdeString.concat("\nsvcEventText=" + this.getSvcEventText());
        pdeString = pdeString.concat("\nfirstReportedTime=" + new Date(this.getFirstReportedTime()));
        Iterator fruIter = this.getFruList().iterator();
        int i = 0;
        while (fruIter.hasNext()) {
            pdeString = pdeString.concat("\nfru " + ++i + "=" + fruIter.next());
        }
        pdeString = pdeString.concat("\ndomain=" + this.getDomainId().getDID());
        return pdeString;
    }

    public void setRioLoopId(String loopId) {
        this._rioLoopId = loopId;
    }

    public String getRioLoopId() {
        return this._rioLoopId;
    }

    public List getPanelData() {
        ArrayList<CaptionValuePairing> panelList = new ArrayList<CaptionValuePairing>();
        CaptionValuePairing cvp1 = new CaptionValuePairing(new BaseMessageText("XPA7661"), new NonLocalizablePanelValue(this.getReportingSystem().getMTMS()));
        cvp1.setDisplayMode(1);
        panelList.add(cvp1);
        cvp1 = this.getNotificationType() != null ? new CaptionValuePairing(new BaseMessageText("XPA7614"), new LocalizablePanelValue(this.getNotificationType())) : new CaptionValuePairing(new BaseMessageText("XPA7614"), new NonLocalizablePanelValue(""));
        cvp1.setDisplayMode(1);
        panelList.add(cvp1);
        cvp1 = new CaptionValuePairing(new BaseMessageText("XPA7615"), new NonLocalizablePanelValue(Integer.toString(this.getPlatformLogID())));
        cvp1.setDisplayMode(1);
        panelList.add(cvp1);
        cvp1 = new CaptionValuePairing(new BaseMessageText("XPA7616"), new NonLocalizablePanelValue(this.getCreatorID()));
        cvp1.setDisplayMode(1);
        panelList.add(cvp1);
        cvp1 = new CaptionValuePairing(new BaseMessageText("XPA7617"), new NonLocalizablePanelValue(this.getRefcode()));
        cvp1.setDisplayMode(1);
        panelList.add(cvp1);
        cvp1 = new CaptionValuePairing(new BaseMessageText("XPA7618"), new NonLocalizablePanelValue(Integer.toString(this.getSubsystemID())));
        cvp1.setDisplayMode(1);
        panelList.add(cvp1);
        cvp1 = new CaptionValuePairing(new BaseMessageText("XPA7619"), new LocalizablePanelValue(this.getEventType()));
        cvp1.setDisplayMode(1);
        panelList.add(cvp1);
        cvp1 = new CaptionValuePairing(new BaseMessageText("XPA7622"), new NonLocalizablePanelValue(Integer.toString(this.getEventSeverity())));
        cvp1.setDisplayMode(1);
        panelList.add(cvp1);
        cvp1 = new CaptionValuePairing(new BaseMessageText("XPA7654"), new NonLocalizablePanelValue(this.getFailingEnclosureSystem().getMTMS()));
        cvp1.setDisplayMode(1);
        panelList.add(cvp1);
        cvp1 = new CaptionValuePairing(new BaseMessageText("XPA7635"), new NonLocalizablePanelValue(this.getSvcEventText()));
        cvp1.setDisplayMode(1);
        panelList.add(cvp1);
        cvp1 = new CaptionValuePairing(new BaseMessageText("XPA7655"), new LocalizableTimePanelValue(this.getFirstReportedTime()));
        cvp1.setDisplayMode(1);
        panelList.add(cvp1);
        return panelList;
    }

    public static void main(String[] args) {
        byte[] pelData = new byte[]{80, 72, 0, 48, 1, 0, 73, 79, 32, 4, 2, 32, 17, 1, 86, -104, 32, 4, 2, 32, 17, 1, 87, 20, 87, 0, 1, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -126, 0, 8, 60, 80, 13, 62, -47, 85, 72, 0, 24, 1, 0, 0, 0, 96, 3, 64, 0, 0, 0, 0, 0, 0, 0, -88, 0, 0, 0, 0, 0, 80, 83, 0, 80, 1, 0, 0, 0, 2, 0, 0, 7, 0, 0, 0, 72, 0, 0, 0, 96, 0, 0, 0, 64, 16, 0, 0, 18, 0, 0, -4, -16, 0, 0, 0, 0, 36, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 49, 48, 48, 48, 57, 48, 70, 48, 48, 48, 51, 67, 48, 53, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 77, 84, 0, 28, 1, 0, 0, 0, 57, 49, 49, 49, 45, 53, 50, 48, 49, 48, 45, 48, 48, 55, 50, 65, 0, 0, 0, 0};
        PelDataEvent pde = new PelDataEvent(new Object());
        pde.setSystem(new PASystem("tttt", "mmm", "ssssssssssss"));
        pde.setData(pelData);
    }
}

